#ifndef _DRV_LVR_H
#define _DRV_LVR_H
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用函數 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
/**
 * @brief 若電壓滿足以下定義的低電壓復位值且保持時間大於 tLVR，則 MCU 復位，此時復位後暫存器內容不變
 * 若寫入以下四個定義的復位電壓值外也將導致 MCU 在 tSRESET 時間後復位，此時復位後暫存器回復為上電默認值1.7V
 *
 */
#define  SET_LVR_1V7()			    { _lvrc = 0x66;}
#define  SET_LVR_1V9()			    { _lvrc = 0x55;}
#define  SET_LVR_2V55()			    { _lvrc = 0x33;}
#define  SET_LVR_3V15()			    { _lvrc = 0x99;}
#define  SET_LVR_3V8()			    { _lvrc = 0xAA;}
#define  SET_LVR_Disable()			{ _lvrc = 0xA5;}
// 复位操作会在 tSRESET 时间后执行。注意的是此处单片机复位后，寄存器的值将恢复到上电复位值
#define SET_LVR_RESET_MCU()         { _lvrc = 0xFF;while(1);}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 變量聲明 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

#endif

